DROP PROCEDURE [hips].[AddressInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 15 October 2012
-- Description:   Inserts a new record into the Address Table
-- =============================================
CREATE PROCEDURE [hips].[AddressInsert]
(
       @AddressLine1 VARCHAR(100)
      ,@AddressLine2 VARCHAR(100) = null
      ,@PlaceName VARCHAR(100) = null
      ,@AustralianStateId INT
      ,@InternationalStateCode VARCHAR(10) = NULL
      ,@Postcode VARCHAR(10) = null
      ,@CountryId INT
      ,@AddressTypeId INT
	  ,@UserModified varchar(256)
)
AS
BEGIN
    SET NOCOUNT ON
    DECLARE @intErrorCode INT,
			@AddressId  INT
    SET @intErrorCode = 0
    INSERT
     INTO [hips].[Address]
         ( [AddressLine1],
           [AddressLine2],
           [PlaceName],
           [AustralianStateId],
           [InternationalStateCode],
           postcode,
           [CountryId],
           [AddressTypeId],
           [DateCreated],
           [UserCreated],
           [DateModified],
           [UserModified]
         )
    VALUES
         (
            @AddressLine1
           ,@AddressLine2
           ,@PlaceName
           ,@AustralianStateId
           ,@InternationalStateCode
           ,@Postcode
           ,@CountryId
           ,@AddressTypeId
          , GETDATE()
          , @UserModified
          , GETDATE()
          , @UserModified
         )
    SELECT @intErrorCode = @@ERROR 
           , @AddressId = SCOPE_IDENTITY()
    IF @intErrorCode = 0
    BEGIN
       SELECT  a.AddressId,
		a.AddressLine1,
		a.AddressLine2,
		a.PlaceName,
		a.AustralianStateId,
		st.Description AS AustralianStateName,
		a.InternationalStateCode,
		a.PostCode,
		a.CountryId,
		c.DESCRIPTION AS CountryName,
		a.AddressTypeId,
		at.DESCRIPTION AS AddressTypeDescription,
		a.DateCreated,
		a.UserCreated,
		a.DateModified,
		a.UserModified
		
FROM  hips.Address a
LEFT OUTER JOIN hips.State AS st ON st.StateID = a.AustralianStateId
Inner JOIN hips.Country AS c ON c.CountryId = a.CountryId
INNER JOIN hips.AddressType AS at ON at.AddressTypeId = a.AddressTypeId
WHERE a.AddressId = @AddressId
    END
    RETURN(@intErrorCode)
END
GO

